import sys
import smtplib
import os
import optparse
import datetime

from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email.MIMEImage import MIMEImage
from email.MIMEText import MIMEText
from email.Utils import COMMASPACE, formatdate
from email import Encoders

from base64 import decodestring

username = sys.argv[2]
hostname = sys.argv[3]
port = sys.argv[4]
from_addr = sys.argv[5]
to_addr = sys.argv[6]
subject = sys.argv[7]

Title = sys.argv[8]
DateTime = datetime.datetime.now().strftime("%H:%M on %B %d, %Y")
UserEmail = sys.argv[9]
Info = sys.argv[10]
Message = sys.argv[11]

AddScreenshot = sys.argv[12]
AddLogs = sys.argv[13]

IMAGEmime = sys.argv[14]
LOGmime = sys.argv[15]
CRASHmime = sys.argv[16]

with open(sys.argv[1], 'r') as htmlFile:
    file_text = htmlFile.read().replace('\n', '')
html = file_text.format(Title, UserEmail, DateTime, Info)

password = getpass.getpass() if sys.stdin.isatty() else sys.stdin.readline().rstrip('\n')

message = MIMEMultipart()
message['From'] = from_addr
message['To'] = to_addr
message['Date'] = formatdate(localtime=True)
message['Subject'] = subject
message['template_id'] = '070ee46a-6787-48f1-b48f-b09215599778'
message.attach(MIMEText(html, 'html'))

if AddScreenshot is '1' :
    f = open(IMAGEmime, 'rb');
    msgImage = MIMEImage(f.read())
    f.close()
    msgImage.add_header('Content-Disposition', 'attachment', filename='screenshot.png')
    message.attach(msgImage)

if AddLogs is '1' :
    f = open(LOGmime, 'rb');
    msgLog = MIMEText(f.read())
    f.close()
    msgLog.add_header('Content-Disposition', 'attachment', filename='output_log.log')
    message.attach(msgLog)

f = open(CRASHmime, 'rb');
msgCrash = MIMEText(f.read())
f.close()
msgCrash.add_header('Content-Disposition', 'attachment', filename='crash_report.xml')
message.attach(msgCrash)

smtp = smtplib.SMTP(hostname, port)
smtp.starttls()
smtp.login(username, password)
del password

smtp.sendmail(from_addr, to_addr, message.as_string())
smtp.close()

sys.exit(0)